/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.api.io;

import fr.obeo.dsl.viewpoint.collab.activity.model.activitymetadata.ActivityMetadataExport;
import fr.obeo.dsl.viewpoint.collab.activity.model.internal.activitymetadata.HistoryDataUtil;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.ErrorResponse;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.project.NewSharedModelingProjectResponse;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.repository.DeletedRepositoryResponse;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.repository.GetRepositoriesResponse;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.repository.NewRepositoryResponse;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.repository.Repository;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.repository.operation.ExportRepositoryResponse;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.repository.operation.ImportRespositoryResponse;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.repository.operation.RepositoryHistoryResponse;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.repository.operation.RepositoryStartedResponse;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.repository.operation.RepositoryStoppedResponse;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.user.CreatedUserResponse;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.user.DeleteUserResponse;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.user.GetUsersResponse;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.user.SimpleUser;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.user.UpdatedUserResponse;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.command.CloseCommandResponse;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.command.osgi.OSGiCommandResponse;
import java.util.List;

public final class ResponseFactory {
    private ResponseFactory() {
    }

    public static ErrorResponse createErrorResponse(String message, int status, String error) {
        ErrorResponse errorResponse = new ErrorResponse();
        errorResponse.setMessage(message);
        errorResponse.setStatus(status);
        errorResponse.setError(error);
        return errorResponse;
    }

    public static NewRepositoryResponse createNewRepositoryResponse(Repository repository) {
        NewRepositoryResponse newRepositoryResponse = new NewRepositoryResponse();
        newRepositoryResponse.setMessage(String.format("The repository %1$s has been created.", repository.getName()));
        newRepositoryResponse.setStatus(201);
        newRepositoryResponse.setRepository(repository);
        return newRepositoryResponse;
    }

    public static DeletedRepositoryResponse createDeletedRepositoryResponse(String repositoryName, boolean isDatabaseDeleted) {
        DeletedRepositoryResponse deletedRepositoryResponse = new DeletedRepositoryResponse();
        deletedRepositoryResponse.setMessage(String.format("The repository %1$s has been completely deleted.", repositoryName));
        deletedRepositoryResponse.setStatus(200);
        deletedRepositoryResponse.setRepositoryName(repositoryName);
        deletedRepositoryResponse.setDatabaseDeleted(isDatabaseDeleted);
        return deletedRepositoryResponse;
    }

    public static RepositoryStartedResponse createRepositoryStartedResponse(Repository repository, boolean dropData) {
        RepositoryStartedResponse repositoryStartedResponse = new RepositoryStartedResponse();
        if (dropData) {
            repositoryStartedResponse.setMessage(String.format("The repository %1$s has been started after reinitialization.", repository.getName()));
        } else {
            repositoryStartedResponse.setMessage(String.format("The repository %1$s has been started.", repository.getName()));
        }
        repositoryStartedResponse.setStatus(200);
        repositoryStartedResponse.setRepository(repository);
        return repositoryStartedResponse;
    }

    public static RepositoryHistoryResponse createRepositoryHistoryResponse(Repository repository, ActivityMetadataExport commitHistory) {
        RepositoryHistoryResponse repositoryHistoryResponse = new RepositoryHistoryResponse();
        repositoryHistoryResponse.setMessage(String.format("Commit history exported for repository %1$s.", repository.getName()));
        repositoryHistoryResponse.setStatus(200);
        repositoryHistoryResponse.setActivityMetadataExport(HistoryDataUtil.createHistoryActivityMetadataExport((ActivityMetadataExport)commitHistory));
        return repositoryHistoryResponse;
    }

    public static RepositoryStoppedResponse createRepositoryStoppedResponse(Repository repository) {
        RepositoryStoppedResponse repositoryStoppedResponse = new RepositoryStoppedResponse();
        repositoryStoppedResponse.setMessage(String.format("The repository %1$s has been stopped.", repository.getName()));
        repositoryStoppedResponse.setRepository(repository);
        repositoryStoppedResponse.setStatus(200);
        return repositoryStoppedResponse;
    }

    public static CloseCommandResponse createCloseCommandResponse() {
        CloseCommandResponse closeCommandResponse = new CloseCommandResponse();
        closeCommandResponse.setMessage("The server is stopping...");
        closeCommandResponse.setStatus(200);
        return closeCommandResponse;
    }

    public static OSGiCommandResponse createOSGiSuccessCommandResponse(String command, List<Object> params, String result) {
        OSGiCommandResponse osgiCommandResponse = new OSGiCommandResponse();
        osgiCommandResponse.setCommand(command);
        osgiCommandResponse.setParameters(params);
        osgiCommandResponse.setResult(result);
        osgiCommandResponse.setMessage(String.format("The command %1$s %2$s has been correctly executed", command, params));
        osgiCommandResponse.setStatus(200);
        return osgiCommandResponse;
    }

    public static OSGiCommandResponse createOSGiErrorCommandResponse(String command, List<Object> params, String result) {
        OSGiCommandResponse osgiCommandResponse = new OSGiCommandResponse();
        osgiCommandResponse.setCommand(command);
        osgiCommandResponse.setParameters(params);
        osgiCommandResponse.setResult(result);
        osgiCommandResponse.setMessage(String.format("The command %1$s %2$s has NOT been correctly executed", command, params));
        osgiCommandResponse.setStatus(500);
        return osgiCommandResponse;
    }

    public static GetRepositoriesResponse createGetRepositoriesResponse(List<Repository> allRepositories) {
        GetRepositoriesResponse getRepositoriesResponse = new GetRepositoriesResponse();
        getRepositoriesResponse.setMessage("All available repositories");
        getRepositoriesResponse.setStatus(200);
        getRepositoriesResponse.setRepositories(allRepositories);
        return getRepositoriesResponse;
    }

    public static NewSharedModelingProjectResponse createNewSharedModelingProjectResponse(String projectName, String repositoryName) {
        NewSharedModelingProjectResponse newSharedModelingProjectResponse = new NewSharedModelingProjectResponse();
        newSharedModelingProjectResponse.setMessage(String.format("The project %1$s has been successfully created in the repository %2$s.", projectName, repositoryName));
        newSharedModelingProjectResponse.setStatus(201);
        newSharedModelingProjectResponse.setProjectName(projectName);
        newSharedModelingProjectResponse.setRepositoryName(repositoryName);
        return newSharedModelingProjectResponse;
    }

    public static GetUsersResponse createGetUsersResponse(List<SimpleUser> allUsers, String repositoryName) {
        GetUsersResponse getUsersResponse = new GetUsersResponse();
        getUsersResponse.setMessage(String.format("The list of users for the repository %1$s.", repositoryName));
        getUsersResponse.setStatus(200);
        getUsersResponse.setRepositoryName(repositoryName);
        getUsersResponse.setUsers(allUsers);
        return getUsersResponse;
    }

    public static CreatedUserResponse createNewUserResponse(SimpleUser user, String repositoryName) {
        CreatedUserResponse newUserResponse = new CreatedUserResponse();
        String message = user.getPermissions() == null || user.getPermissions().isEmpty() ? String.format("The user %1$s has been created in the repository %2$s.", user.getId(), repositoryName) : String.format("The user %1$s has been created in the repository %2$s with the permissions %3$s.", user.getId(), repositoryName, user.getPermissions());
        newUserResponse.setMessage(message);
        newUserResponse.setStatus(201);
        newUserResponse.setProjectNames(user.getPermissions());
        newUserResponse.setRepositoryName(repositoryName);
        newUserResponse.setUser(user);
        return newUserResponse;
    }

    public static DeleteUserResponse createDeletedUserResponse(String repositoryName, String username) {
        DeleteUserResponse deleteUserResponse = new DeleteUserResponse();
        deleteUserResponse.setMessage(String.format("The user %1$s has been deleted from the repository %2$s.", username, repositoryName));
        deleteUserResponse.setStatus(200);
        deleteUserResponse.setRepositoryName(repositoryName);
        return deleteUserResponse;
    }

    public static UpdatedUserResponse createUpdatedUserResponse(String repositoryName, String userName, SimpleUser user) {
        UpdatedUserResponse updatedUserResponse = new UpdatedUserResponse();
        updatedUserResponse.setMessage(String.format("The user %1$s has been updated in the repository %2$s.", userName, repositoryName));
        updatedUserResponse.setStatus(200);
        updatedUserResponse.setRepositoryName(repositoryName);
        updatedUserResponse.setUser(user);
        return updatedUserResponse;
    }

    public static ExportRepositoryResponse createExportedRepositoryResponse(String repositoryName, String url) {
        ExportRepositoryResponse exportRepositoryResponse = new ExportRepositoryResponse();
        exportRepositoryResponse.setMessage(String.format("The export for the repository %1$s as been launched. You will be able to retrieved the exported data at the url: %2$s", repositoryName, url));
        exportRepositoryResponse.setStatus(202);
        exportRepositoryResponse.setRepository(repositoryName);
        exportRepositoryResponse.setUrl(url);
        return exportRepositoryResponse;
    }

    public static ImportRespositoryResponse createImportRepositoryResponse(String repositoryName) {
        ImportRespositoryResponse importRespositoryResponse = new ImportRespositoryResponse();
        importRespositoryResponse.setMessage(String.format("The data are being imported to the repository %1$s. The state of the repository will be the same after and before the import.", repositoryName));
        importRespositoryResponse.setStatus(202);
        importRespositoryResponse.setRepository(repositoryName);
        return importRespositoryResponse;
    }

    public static ErrorResponse createBadRequestErrorResponse(String message, String error) {
        return ResponseFactory.createErrorResponse(message, 400, error);
    }

    public static ErrorResponse createInternalServerErrorResponse(String message, String error) {
        return ResponseFactory.createErrorResponse(message, 500, error);
    }

    public static ErrorResponse createNotFoundErrorResponse(String message, String error) {
        return ResponseFactory.createErrorResponse(message, 404, error);
    }

    public static ErrorResponse createUnauthorizedErrorResponse(String message, String error) {
        return ResponseFactory.createErrorResponse(message, 401, error);
    }
}

