/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.internal.command.osgi;

import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.AbstractResponse;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.ResponseFactory;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.OM;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.command.exception.AbstractCommandExecutionException;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.command.exception.CommandExecutionException;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.command.exception.CommandValidityException;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.command.exception.PreparingCommandExecutionContextException;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.command.osgi.AdminServerCollabPrintStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Function;
import org.apache.felix.service.threadio.ThreadIO;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class OSGiCommandExecutionHelper {
    public static final String RESULT_ERROR = "FAILURE";
    private static final String RESULT_ERROR_SECURITY_MANAGER_NOT_FOUND = "Security manager not found for";
    private static final String RESULT_ERROR_REPOSITORY_NOT_FOUND = "Repository not found:";
    private static final String COMMAND_PARAMETER_NAME = "command";
    private static final String CONTEXT_PARAMETER_NAME = "context";
    private static final String PARMS_PARAMETER_NAME = "params";
    private static final String ALL_OSGI_CONTEXTS = "*";
    private static final String CONTEXT_COMMAND_SEPARATOR = ":";
    private String command;
    private String context;
    private List<Object> params;
    private ThreadIO threadIO;
    private CommandSession commandSession;
    private boolean commandExecuted;

    public OSGiCommandExecutionHelper(HttpServletRequest req) {
        this(req.getParameter(COMMAND_PARAMETER_NAME), Optional.ofNullable(req.getParameter(CONTEXT_PARAMETER_NAME)).orElse(ALL_OSGI_CONTEXTS), Optional.ofNullable(req.getParameter(PARMS_PARAMETER_NAME)).map(String::trim).map(s -> s.split(",")).map(stringArray -> Arrays.asList(stringArray)).map(l -> l.stream().map(Object.class::cast).collect(Collectors.toList())).orElse(Collections.emptyList()));
    }

    public OSGiCommandExecutionHelper(String command, String context, List<Object> parameters) {
        this.command = command;
        this.context = context;
        this.params = parameters;
    }

    public void checkCommand() throws AbstractCommandExecutionException {
        if (this.command == null) {
            throw new CommandValidityException();
        }
    }

    public void prepareCommandExecutionContext() throws AbstractCommandExecutionException {
        this.threadIO = this.initializeThreadIO();
        if (this.threadIO == null) {
            throw new PreparingCommandExecutionContextException();
        }
        this.commandSession = this.initializeCommandSession(this.threadIO);
        if (this.commandSession == null) {
            throw new PreparingCommandExecutionContextException();
        }
    }

    public AbstractResponse executeCommand() throws AbstractCommandExecutionException {
        String osgiCommand = this.buildOSGiCommand();
        this.commandExecuted = this.doExecuteCommand(osgiCommand);
        if (!this.commandExecuted) {
            throw new CommandExecutionException(osgiCommand, this.params);
        }
        return this.processResult();
    }

    public AbstractResponse sendError(AbstractCommandExecutionException exception) {
        exception.sendError();
        return ResponseFactory.createErrorResponse(String.format("The command %1$s has not been executed", this.command), exception.getStatusCode(), exception.getLocalizedMessage());
    }

    private ThreadIO initializeThreadIO() {
        BundleContext bundleContext = OM.Activator.getBundleContext();
        ServiceReference threadIOServiceReference = bundleContext.getServiceReference(ThreadIO.class);
        return (ThreadIO)bundleContext.getService(threadIOServiceReference);
    }

    private CommandSession initializeCommandSession(ThreadIO threadio) {
        CommandSession commandSessionToCreate = null;
        BundleContext bundleContext = OM.Activator.getBundleContext();
        ServiceReference commandProcessorServiceReference = bundleContext.getServiceReference(CommandProcessor.class);
        CommandProcessor commandProcessor = (CommandProcessor)bundleContext.getService(commandProcessorServiceReference);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        AdminServerCollabPrintStream adminServerCollabPrintStream = new AdminServerCollabPrintStream(byteArrayOutputStream);
        threadio.setStreams(System.in, (PrintStream)adminServerCollabPrintStream, System.err);
        commandSessionToCreate = commandProcessor.createSession(System.in, (OutputStream)adminServerCollabPrintStream, (OutputStream)System.err);
        return commandSessionToCreate;
    }

    private String buildOSGiCommand() {
        String tempContext = this.context;
        String tempCommand = this.command;
        String[] splitedCommand = this.command.split(CONTEXT_COMMAND_SEPARATOR);
        if (splitedCommand.length > 1) {
            tempCommand = splitedCommand[1];
            if (!splitedCommand[0].equals(ALL_OSGI_CONTEXTS)) {
                tempContext = splitedCommand[0];
            }
        }
        return String.join((CharSequence)CONTEXT_COMMAND_SEPARATOR, tempContext, tempCommand);
    }

    private boolean doExecuteCommand(String osgiCommand) {
        boolean isCommandExecuted = true;
        try {
            Object commandToExecute = this.commandSession.get(osgiCommand);
            if (commandToExecute instanceof Function) {
                Function functionToExecute = (Function)commandToExecute;
                functionToExecute.execute(this.commandSession, this.params);
            }
        }
        catch (Exception e) {
            OM.LOG.error(String.format("Could not execute the %1$s command with %2$s parameters", osgiCommand, this.params), (Throwable)e);
            isCommandExecuted = false;
        }
        return isCommandExecuted;
    }

    private AbstractResponse processResult() {
        AdminServerCollabPrintStream printStream = (AdminServerCollabPrintStream)this.commandSession.getConsole();
        String message = printStream.asString();
        if (message.contains(RESULT_ERROR) || message.contains(RESULT_ERROR_REPOSITORY_NOT_FOUND) || message.contains(RESULT_ERROR_SECURITY_MANAGER_NOT_FOUND)) {
            return ResponseFactory.createOSGiErrorCommandResponse(this.command, this.params, printStream.asString());
        }
        return ResponseFactory.createOSGiSuccessCommandResponse(this.command, this.params, printStream.asString());
    }

    public void closeCommandExecutionContext() {
        if (this.commandSession != null) {
            this.commandSession.close();
        }
        if (this.threadIO != null) {
            this.threadIO.close();
        }
        if (this.commandExecuted) {
            Optional.of(this.commandSession).map(CommandSession::getConsole).filter(AdminServerCollabPrintStream.class::isInstance).map(AdminServerCollabPrintStream.class::cast).map(AdminServerCollabPrintStream::asString).ifPresent(System.out::println);
        }
        this.commandSession = null;
        this.threadIO = null;
    }

    public String getCommand() {
        return this.command;
    }

    public List<Object> getParams() {
        return this.params;
    }
}

