/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.internal.util;

import fr.obeo.dsl.viewpoint.collab.server.admin.api.AdminServerConfigurationHelper;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.IAdminServlet;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.monitoring.HealthEndpoint;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.monitoring.InfoEndpoint;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.monitoring.MetricsEndpoint;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.project.SharedModelingProjectResource;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.project.SharedModelingProjectsResource;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.repository.RepositoriesResource;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.repository.RepositoryResource;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.repository.operation.ExportRepositoryResource;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.repository.operation.ExportStaticResourceServlet;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.repository.operation.HistoryRepositoryResource;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.repository.operation.ImportRepositoryResource;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.repository.operation.OpenApiStaticResourceServlet;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.repository.operation.StartRepositoryResource;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.repository.operation.StopRepositoryResource;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.task.TaskResource;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.user.UserResource;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.user.UsersResource;
import fr.obeo.dsl.viewpoint.collab.server.admin.doc.internal.OM;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.AdminServletContextHelper;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.DefaultAdminServlet;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.OM;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.command.CloseCommandResource;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.command.osgi.OSGiCommandResource;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.extension.module.AdminServletDescriptorRegistry;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.extension.module.IAdminServletDescriptor;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.util.ReflectionHelper;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.http.jetty.JettyConfigurator;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.net4j.ws.jetty.Net4jWebSocketServlet;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.http.context.ServletContextHelper;

public final class JettyServerUtil {
    private static final String SERVER_NAME = "REST_ADMIN_SERVER";
    private static final String WHITEBOARD_CONTEXT_NAME = "REST_ADMIN";
    private static final String PATH_SEPARATOR = "/";
    private static final String WHITEBOARD_CONTEXT_PATH = "/";
    private static final String CONTEXT_PATH = "/";
    private static final String CUSTOMERS_CONTEXT_PATH = "/api/v1.0/specific";

    private JettyServerUtil() {
    }

    public static void startJettyServer(BundleContext context) {
        Object keystoreType;
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        AdminServerConfigurationHelper adminServerConfigurationHelper = AdminServerConfigurationHelper.getInstance();
        ((Dictionary)properties).put("customizer.class", "fr.obeo.dsl.viewpoint.collab.server.admin.jetty.customizer.RestAdminJettyCustomizer");
        ((Dictionary)properties).put("http.enabled", adminServerConfigurationHelper.isHttpEnabled());
        ((Dictionary)properties).put("http.host", adminServerConfigurationHelper.getHttpHost());
        ((Dictionary)properties).put("http.port", adminServerConfigurationHelper.getHttpPort());
        ((Dictionary)properties).put("https.enabled", adminServerConfigurationHelper.isHttpsEnabled());
        ((Dictionary)properties).put("https.host", adminServerConfigurationHelper.getHttpsHost());
        ((Dictionary)properties).put("https.port", adminServerConfigurationHelper.getHttpsPort());
        ((Dictionary)properties).put("ssl.keystore", adminServerConfigurationHelper.getKeystorePath());
        ((Dictionary)properties).put("ssl.password", adminServerConfigurationHelper.getKeystorePassphrase());
        String keyPassword = adminServerConfigurationHelper.getKeyPassword();
        if (keyPassword != null) {
            ((Dictionary)properties).put("ssl.keypassword", keyPassword);
        }
        if ((keystoreType = adminServerConfigurationHelper.get("admin.server.jetty.ssl.keystore.type")) != null) {
            ((Dictionary)properties).put("ssl.keystoretype", keystoreType);
        }
        ((Dictionary)properties).put("context.path", "/");
        try {
            JettyConfigurator.startServer((String)SERVER_NAME, properties);
        }
        catch (Exception e) {
            throw new IllegalStateException("The server could not be started", e);
        }
    }

    public static void registerDefaultServlet(BundleContext context) {
        Hashtable<String, String> servletContextHelperProperties = new Hashtable<String, String>();
        ((Dictionary)servletContextHelperProperties).put("osgi.http.whiteboard.context.name", WHITEBOARD_CONTEXT_NAME);
        ((Dictionary)servletContextHelperProperties).put("osgi.http.whiteboard.context.path", "/");
        context.registerService(ServletContextHelper.class, (Object)new AdminServletContextHelper(), servletContextHelperProperties);
        JettyServerUtil.registerServlet(context, "/", new DefaultAdminServlet());
    }

    public static void registerRestAdminServlets(BundleContext context) throws IOException {
        JettyServerUtil.registerServlet(context, "/api/v1.0/command", new OSGiCommandResource());
        JettyServerUtil.registerServlet(context, "/api/v1.0/close", new CloseCommandResource());
        JettyServerUtil.registerServlet(context, "/api/v1.0/repositories", new RepositoriesResource());
        JettyServerUtil.registerServlet(context, "/api/v1.0/repositories/*", new RepositoryResource());
        JettyServerUtil.registerServlet(context, "/api/v1.0/repositories/history/*", new HistoryRepositoryResource());
        JettyServerUtil.registerServlet(context, "/api/v1.0/repositories/start/*", new StartRepositoryResource());
        JettyServerUtil.registerServlet(context, "/api/v1.0/repositories/stop/*", new StopRepositoryResource());
        JettyServerUtil.registerServlet(context, "/api/v1.0/repositories/export/*", new ExportRepositoryResource());
        Hashtable<String, Object> importRepoProps = new Hashtable<String, Object>();
        ((Dictionary)importRepoProps).put("equinox.http.multipartSupported", Boolean.TRUE);
        JettyServerUtil.registerServlet(context, "/api/v1.0/repositories/import/*", new ImportRepositoryResource(), importRepoProps);
        JettyServerUtil.registerServlet(context, "/api/v1.0/projects", new SharedModelingProjectsResource());
        JettyServerUtil.registerServlet(context, "/api/v1.0/projects/*", new SharedModelingProjectResource());
        JettyServerUtil.registerServlet(context, "/api/v1.0/tasks/*", new TaskResource());
        JettyServerUtil.registerServlet(context, "/api/v1.0/users", new UsersResource());
        JettyServerUtil.registerServlet(context, "/api/v1.0/users/*", new UserResource());
        JettyServerUtil.registerServlet(context, "/api/v1.0/exports/repositories/*", new ExportStaticResourceServlet(ExportRepositoryResource.getExportResultResourceRoot()));
        JettyServerUtil.registerServlet(context, "/api/v1.0/exports/projects/*", new ExportStaticResourceServlet(SharedModelingProjectResource.getExportResultResourceRoot()));
        Path logsFolder = Paths.get(AdminServerConfigurationHelper.getInstance().getLocalClientCallLogsDirectoryPath(), "logs");
        Files.createDirectories(logsFolder, new FileAttribute[0]);
        JettyServerUtil.registerServlet(context, "/api/v1.0/exports/logs/*", new ExportStaticResourceServlet(logsFolder));
        JettyServerUtil.registerDocumentation(context);
        JettyServerUtil.registerServlet(context, "/monitoring/health", new HealthEndpoint());
        JettyServerUtil.registerServlet(context, "/monitoring/info", new InfoEndpoint());
        JettyServerUtil.registerServlet(context, "/monitoring/metrics", new MetricsEndpoint());
        JettyServerUtil.registerExtension(context);
    }

    private static void registerDocumentation(BundleContext context) {
        if (!AdminServerConfigurationHelper.getInstance().isDocAndOpenApiServletsEnabled()) {
            OM.LOG.info("REST Admin - /doc and /openapi servlets disabled.");
            return;
        }
        JettyServerUtil.registerServlet(context, "/openapi/*", new OpenApiStaticResourceServlet());
        try {
            String docDirectoryPath = AdminServerConfigurationHelper.getInstance().getDocDirectoryPath();
            Bundle docBundle = OM.Activator.getBundleContext().getBundle();
            String docResourceBase = AdminServerConfigurationHelper.getDirectoryPathFromProperties(docDirectoryPath, docBundle);
            Hashtable<String, String> documentationStaticResourcesProperties = new Hashtable<String, String>();
            ((Dictionary)documentationStaticResourcesProperties).put("osgi.http.whiteboard.servlet.pattern", "/doc/*");
            ((Dictionary)documentationStaticResourcesProperties).put("servlet.init.dirAllowed", "false");
            ((Dictionary)documentationStaticResourcesProperties).put("servlet.init.resourceBase", docResourceBase);
            context.registerService(Servlet.class, (Object)new DefaultServlet(){

                public ServletContext getServletContext() {
                    ServletContext servletContext = super.getServletContext();
                    ServletContext context2 = servletContext.getContext("/doc/");
                    if (context2 != null) {
                        return context2;
                    }
                    return servletContext;
                }
            }, documentationStaticResourcesProperties);
        }
        catch (IOException | URISyntaxException e) {
            OM.LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    private static void registerExtension(BundleContext context) {
        List<IAdminServletDescriptor> registeredExtensions = AdminServletDescriptorRegistry.getRegisteredExtensions();
        registeredExtensions.forEach(desc -> {
            IAdminServlet odServlet = desc.getAdminServlet();
            Object alias = desc.getAlias();
            if (!((String)alias).startsWith("/")) {
                alias = "/" + (String)alias;
            }
            Hashtable<String, CallSite> servletProperties = new Hashtable<String, CallSite>();
            ((Dictionary)servletProperties).put("osgi.http.whiteboard.servlet.pattern", (CallSite)((Object)(CUSTOMERS_CONTEXT_PATH + (String)alias)));
            context.registerService(Servlet.class, (Object)odServlet, servletProperties);
        });
    }

    private static void registerServlet(BundleContext context, String alias, HttpServlet service) {
        JettyServerUtil.registerServlet(context, alias, service, new Hashtable<String, Object>());
    }

    private static void registerServlet(BundleContext context, String alias, HttpServlet service, Dictionary<String, Object> props) {
        props.put("osgi.http.whiteboard.servlet.pattern", alias);
        context.registerService(Servlet.class, (Object)service, props);
    }

    public static void registerWebSocketTransport(BundleContext context) {
        Map s;
        Server server;
        Handler handler;
        ServiceReference serviceReference;
        Bundle bundle = Platform.getBundle((String)"org.eclipse.equinox.http.jetty");
        BundleContext bundleContext = bundle.getBundleContext();
        ManagedServiceFactory servFactory = (ManagedServiceFactory)bundleContext.getService(serviceReference = bundleContext.getServiceReference(ManagedServiceFactory.class));
        Optional<Object> servers = ReflectionHelper.getFieldValueWithoutException(servFactory, "servers");
        if (servers.isPresent() && (handler = (server = (Server)(s = (Map)servers.get()).get("org.eclipse.equinox.http.jetty.JettyConfigurator.REST_ADMIN_SERVER")).getHandler()) instanceof ServletContextHandler) {
            ((ServletContextHandler)handler).addServlet(Net4jWebSocketServlet.class, "/net4j");
        }
    }

    public static void stopJettyServer() {
        try {
            JettyConfigurator.stopServer((String)SERVER_NAME);
        }
        catch (Exception e) {
            throw new IllegalStateException("The server could not be stopped", e);
        }
    }
}

