/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.wss;

import java.io.File;
import java.net.URI;
import java.text.MessageFormat;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.dynamic.HttpClientTransportDynamic;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.util.resource.PathResource;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.eclipse.net4j.internal.ws.WSClientConnector;
import org.eclipse.net4j.util.StringUtil;

public class WSSClientConnector
extends WSClientConnector {
    @Override
    public String toString() {
        return MessageFormat.format("WSSClientConnector[{0}]", this.getURL());
    }

    @Override
    protected void doBeforeActivate() throws Exception {
        if (!this.getServiceURI().getScheme().equals("wss")) {
            throw new IllegalArgumentException("Service Uri should have wss:// scheme");
        }
        SslContextFactory.Client sslContextFactory = this.createSslContextFactory();
        ClientConnector clientConnector = new ClientConnector();
        clientConnector.setSslContextFactory(sslContextFactory);
        HttpClient httpClient = new HttpClient((HttpClientTransport)new HttpClientTransportDynamic(clientConnector, new ClientConnectionFactory.Info[0]));
        WebSocketClient securedClient = new WebSocketClient(httpClient);
        this.setClient(securedClient);
        this.ownedClient = true;
        super.doBeforeActivate();
    }

    private SslContextFactory.Client createSslContextFactory() {
        File file;
        SslContextFactory.Client sslContextFactory = new SslContextFactory.Client();
        boolean trustAll = Boolean.getBoolean("org.eclipse.net4j.internal.wss.ssl.trustall");
        String eia = System.getProperties().getProperty("org.eclipse.net4j.internal.wss.ssl.endpointIdentificationAlgorithm");
        String passphrase = System.getProperties().getProperty("org.eclipse.net4j.internal.wss.ssl.passphrase");
        String trusturi = System.getProperties().getProperty("org.eclipse.net4j.internal.wss.ssl.trust");
        String trustType = System.getProperties().getProperty("org.eclipse.net4j.internal.wss.ssl.trust.type");
        String trustAlg = System.getProperties().getProperty("org.eclipse.net4j.internal.wss.ssl.trust.manager.factory.algorithm");
        sslContextFactory.setTrustAll(trustAll);
        if ("null".equals(eia)) {
            sslContextFactory.setEndpointIdentificationAlgorithm(null);
        } else if (!StringUtil.isEmpty((String)eia)) {
            sslContextFactory.setEndpointIdentificationAlgorithm(eia);
        }
        if (trusturi != null && (file = new File(URI.create(trusturi))).exists()) {
            sslContextFactory.setTrustStoreResource((Resource)new PathResource(file));
            sslContextFactory.setTrustStorePassword(passphrase);
            if (!StringUtil.isEmpty((String)trustType)) {
                sslContextFactory.setTrustStoreType(trustType);
            }
            if (!StringUtil.isEmpty((String)trustAlg)) {
                sslContextFactory.setTrustManagerFactoryAlgorithm(trustAlg);
            }
        }
        return sslContextFactory;
    }
}

