/*******************************************************************************
 * Copyright (c) 2025 THALES GLOBAL SERVICES
 * All rights reserved.
 *******************************************************************************/
package fr.obeo.dsl.viewpoint.collab.common.internal.helper;

/**
 * Constants used to get system properties or environment variables.
 * 
 * @author lfasani
 */
public final class CollabConfigHelperPropertiesOrEnvConstants {

    /**
     * Login to connect to the CDO repository server by http request.
     */
    public static final String CDO_USER_LOGIN = "fr.obeo.dsl.viewpoint.collab.credentials.tools.net4j.login"; //$NON-NLS-1$

    /**
     * Password to connect to the CDO repository server by http request.
     */
    public static final String CDO_USER_PASSWORD = "fr.obeo.dsl.viewpoint.collab.credentials.tools.net4j.password"; //$NON-NLS-1$

    /**
     * Repository name to connect to the CDO repository server by http request.
     */
    public static final String CDO_USER_REPONAME = "fr.obeo.dsl.viewpoint.collab.tools.net4j.reponame"; //$NON-NLS-1$

    /**
     * Hostname to connect to the CDO repository server by http request.
     */
    public static final String CDO_USER_HOSTNAME = "fr.obeo.dsl.viewpoint.collab.tools.net4j.hostname"; //$NON-NLS-1$

    /**
     * Port to connect to the CDO repository server by http request.
     */
    public static final String CDO_USER_PORT = "fr.obeo.dsl.viewpoint.collab.tools.net4j.port"; //$NON-NLS-1$

    /**
     * Connection type to connect to the CDO repository server by http request.
     */
    public static final String CDO_USER_CONNECTION_TYPE = "fr.obeo.dsl.viewpoint.collab.tools.net4j.connectiontype"; //$NON-NLS-1$

    /**
     * Login to connect to the Jetty server by http request.
     */
    public static final String ADMIN_SERVER_LOGIN = "fr.obeo.dsl.viewpoint.collab.credentials.tools.http.login"; //$NON-NLS-1$

    /**
     * Password to connect to the Jetty server by http request.
     */
    public static final String ADMIN_SERVER_PASSWORD = "fr.obeo.dsl.viewpoint.collab.credentials.tools.http.password"; //$NON-NLS-1$

    /**
     * Hostname to connect to the Jetty server by http request.
     */
    public static final String ADMIN_SERVER_HOSTNAME = "fr.obeo.dsl.viewpoint.collab.tools.http.hostname"; //$NON-NLS-1$

    /**
     * Port to connect to the Jetty server by http request.
     */
    public static final String ADMIN_SERVER_PORT = "fr.obeo.dsl.viewpoint.collab.tools.http.port"; //$NON-NLS-1$

    /**
     * Password to connect to the Jetty server by http request.
     */
    public static final String ADMIN_SERVER_USEHTTPS = "fr.obeo.dsl.viewpoint.collab.tools.http.usehttps"; //$NON-NLS-1$

    private CollabConfigHelperPropertiesOrEnvConstants() {
        // Prevents instantiation.
    }

}
