/*******************************************************************************
 * Copyright (c) 2025 THALES GLOBAL SERVICES.
 * All rights reserved.
 *
 * Contributors:
 *    Obeo - initial API and implementation
 *******************************************************************************/
package fr.obeo.dsl.viewpoint.collab.common.internal.helper;

import java.util.Optional;

/**
 * This helper holds the logic of how the property is set.
 * 
 * @author lfasani
 */
public final class CollabConfigurationHelper {

    private CollabConfigurationHelper() {
    }

    /**
     * Returns the property with the following order of precedence.</br>
     * - the system property</br>
     * - else the environment variable</br>
     * - else the given default value</br>
     * 
     * The environment variable is looked up twice: first with the given property name, and then a second time with a
     * modified version of the name (converted to upper case, with dots (.) replaced by underscore (_) and dashes (-)
     * removed).
     * 
     * @param propertyName
     *            the name of the property
     * @param defaultValue
     *            the default value
     * @return the property value
     */
    public static String getProperty(String propertyName, String defaultValue) {
        String envVariableName = propertyName.toUpperCase().replace(".", "_").replace("-", ""); //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
        return Optional.ofNullable(System.getProperty(propertyName)) //
                .or(() -> Optional.ofNullable(System.getenv(propertyName))) //
                .or(() -> Optional.ofNullable(System.getenv(envVariableName))).orElse(defaultValue);
    }
}
