/*******************************************************************************
 * Copyright (c) 2022, 2026 THALES GLOBAL SERVICES.
 * All rights reserved.
 *
 * Contributors:
 *    Obeo - initial API and implementation
 *******************************************************************************/
package fr.obeo.dsl.viewpoint.collab.common.internal.openid;

/**
 * OpenID Connect constants commonly used in Collab configuration.
 * 
 * @author mporhel
 */
public final class OpenIdConnectConstants {

    /**
     * Parameter name to get access_token from redirect request. And possible value for user info payload lookup
     * customization <BR/>
     * or for OpenID Connect response type (Implicit Flow).
     */
    public static final String ACCESS_TOKEN = "access_token"; //$NON-NLS-1$

    /**
     * Possible value for OpenID Connect response type (Implicit Flow).<BR/>
     * It corresponds to a request for an access token.
     */
    public static final String TOKEN = "token"; //$NON-NLS-1$

    /**
     * Parameter name to get id_token from redirect request.<BR/>
     * And possible value for user info payload lookup customization.
     */
    public static final String ID_TOKEN = "id_token"; //$NON-NLS-1$

    /**
     * Possible value and default value for user info payload lookup customization.
     */
    public static final String USER_INFO_ENDPOINT = "userInfoEndpoint"; //$NON-NLS-1$

    /**
     * Possible value for OpenID Connect response type and trigger value for "Authentication Flow + PKCE"
     * implementation.
     */
    public static final String CODE = "code"; //$NON-NLS-1$

    /**
     * The discovery url endpoint of an identity provider with OpenID Connect capabilities.
     */
    public static final String DISCOVERY_URL = "discoveryURL"; //$NON-NLS-1$

    /**
     * The tenant property name.
     */
    public static final String TENANT = "tenant"; //$NON-NLS-1$

    /**
     * The clientID property name.
     */
    public static final String CLIENT_ID = "clientID"; //$NON-NLS-1$

    /**
     * The scope property name.
     */
    public static final String SCOPE = "scope"; //$NON-NLS-1$

    /**
     * The responseType property name.
     */
    public static final String RESPONSE_TYPE = "responseType"; //$NON-NLS-1$
    
    /**
     * The acrValues property name.
     */
    public static final String ACR_VALUES = "acrValues"; //$NON-NLS-1$
    

    /**
     * The complement property name.
     */
    public static final String COMPLEMENT = "complement"; //$NON-NLS-1$

    /**
     * The login timeout (ms) property name - only used in Authentication Code Flow.
     */
    public static final String LOGIN_TIMEOUT_MS = "login.timeout.ms"; //$NON-NLS-1$

    /**
     * The loopback server name property name - only used in Authentication Code Flow.
     */
    public static final String LOOPBACK_SERVER_PORT = "loopback.server.name"; //$NON-NLS-1$

    /**
     * The loopback server port property name - only used in Authentication Code Flow.
     */
    public static final String LOOPBACK_SERVER_NAME = "loopback.server.port"; //$NON-NLS-1$

    /**
     * Used to indicate where to look for user info. <br/>
     * Accepted values: access_token, id_token, userInfoEndpoint <br/>
     * Default value if empty: userInfoEndpoint
     */
    public static final String USER_INFO_PAYLOAD = "userInfoPayload"; //$NON-NLS-1$

    /**
     * The userInfoMatchClaim property name.
     */
    public static final String USER_INFO_MATCH_CLAIM = "userInfoMatchClaim"; //$NON-NLS-1$

    /**
     * This class should not be instantiated as it only contains constants.
     */
    private OpenIdConnectConstants() {

    }

}
