#!/bin/bash

### BEGIN INIT INFO
# Provides:          ObeoLicensesServer
# Required-Start:    $remote_fs $syslog $network
# Required-Stop:     $remote_fs $syslog $network
# Default-Start:     2 3 4 5
# Default-Stop:      0 1 6
# Short-Description: Start and stop Obeo Licenses Server
# Description:       Obeo Licenses Server provides provides floating licenses for users of products provided by Obeo
### END INIT INFO

RETVAL=0
PIDFILE=./ObeoLicensesServer.pid
# You might want to use a system-wide pid file depending on your deployement
#PIDFILE=/var/run/ObeoLicensesServer.pid
LOGFILE=./ObeoLicensesServer.log
ERRFILE=/dev/null #./ObeoLicensesServer.err

prog=lic-server
exec=./lic-server

if [ -f  /etc/sysconfig/$prog ]; then
    . /etc/sysconfig/$prog
fi

start () {
    [ -x $exec ] || exit 5
    echo -n $"Starting Obeo Licenses Server: "
    if [ ! -e "$PIDFILE" ]; then
        export PIDFILE        
        PID=`$exec -consoleLog > $LOGFILE 2>$ERRFILE & echo $!`
        sleep 5
	    #echo "Saving PID" $PID " to " $PIDFILE
        if [ -z "$PID" ]; then
            printf "%s\n" "[FAILED], see $LOGFILE for details."
        else
            echo "$PID" > $PIDFILE        
            PGID=`ps -o pgid "$PID" | grep -o '[0-9]*'`
            if [ -z "$PGID" ]; then
              rm $PIDFILE
              printf "%s\n" "[FAILED], see $LOGFILE for details."
            else            
              printf "%s\n" "[OK]"
            fi
        fi
    else 
        echo "[FAILED], see $LOGFILE for details."
        readPID
    fi

    RETVAL=$?
    echo
    return $RETVAL
}


stop () {
    echo -n $"Shutting down Obeo Licenses Server: "
    if [ ! -e "$PIDFILE" ]; then
        echo "Fail"
        RETVAL=13 
        readPID
    else 
        echo
        PID=`cat $PIDFILE`
        echo " . Launcher PID: $PID"
        #the native launcher is short lived and start a java process,
        # we have to end the whole process group
        PIDG=`ps -o pgid "$PID" | grep -o '[0-9]*'`
        echo " . PID Group: $PIDG"
        echo -n " . PIDs: "
        echo `pgrep -g "$PIDG"`
        echo "Stopping the whole process group"
        kill -- -"$PIDG"
        RETVAL=$?
        [ $RETVAL -eq 0 ] && rm -f $PIDFILE
        echo "Obeo Licenses Server stopped"
    fi
    echo
    return $RETVAL
}

restart () {
    stop
    start
}

readPID () {
    if [ ! -e "$PIDFILE" ]; then
        echo "No PID file ($PIDFILE)"
        echo "Possible causes: "
        echo " . Obeo Licenses Server has already been stopped"
        echo " . Obeo Licenses Server has not been launched from this service"
        echo " . the PID file has been deleted"
    else
        PID=`cat $PIDFILE`
        PGID=`ps -o pgid "$PID" | grep -o '[0-9]*'`
        if [ -z "$PGID" ]; then
            echo "Known PID: $PID"  
            echo "No running process nor PID group found for it"
            echo "Obeo Licenses Server was started from this service"
            echo "but it is not running any more."
            echo "Remove PID file ($PIDFILE) to allow a start from this service."
        else
            echo "Obeo Licenses Server is running"
            echo " . Launcher PID: $PID"
            echo " . PID Group: $PGID"
            echo -n " . PIDs: "
            echo `pgrep -g "$PGID"`
        fi
    fi
}

case $1 in
    start)
        start
    ;;
    
    stop)
        stop
    ;;
    
    restart)
        restart
    ;;

    status)
        readPID
    ;;

    *)
        echo $"Usage: $0 {start|stop|restart|status}"
        exit 2
    ;;
esac