@echo off
REM
REM Team for Capella Projects Exporter
REM
REM Documentation is available :
REM * in T4C documentation in "Exporter Configuration" chapter
REM * typing exporter -help (see result in log)
REM
REM Each option can also be added directly on the command line: e.g. "exporter.bat -reponame myRepo -sourceToExport C:\Users\me\Documents\t4c\runtime-T4C"
REM
REM Communication with server using https
REM   - switch httpPort to server https port (default: 8443): -httpPort 8443
REM   - trusted certificate: 
REM      - simply switch the httpsConnection parameter to true: -httpsConnection true
REM   - self-signed certificate: 
REM      - switch the httpsConnection parameter to true: -httpsConnection true
REM      - complete  -vmargs with -Dfr.obeo.dsl.viewpoint.collab.https.jetty.ssl.context.trustall=true
REM      - or install your certificate in the JVM
REM
REM Http credentials can be passed through several ways:
REM   - (default) registered in the secure storage, see Scheduler jobs and/or toolsCredentials.bat
REM   - as program arguments -httpLogin admin and -httpPassword token_value
REM   - in a properties file referenced from program arguments with -httpCredentials httpCredentials.properties
@echo on

cd ../capella

REM Communication with server using http
capellac.exe ^
--launcher.suppressErrors ^
-nosplash -console -consoleLog ^
-data exporter-workspace ^
-application com.thalesgroup.mde.melody.collab.exporter ^
-repositoryCredentials ../tools/repositoryCredentials.properties ^
-closeserveronfailure false ^
-overrideExistingProject false ^
-mergeDifferenceOnExistingProjects false ^
-stopRepositoryOnFailure false ^
-httpHost localhost ^
-httpPort 8080 ^
-httpsConnection false ^
%* ^
-vmargs -Xms1000m -Xmx3000m -Xss4m ^
-XX:+UseG1GC -XX:+UseStringDeduplication ^
-Dorg.eclipse.net4j.util.om.trace.disable=true ^
-Dosgi.requiredJavaVersion=17 ^
-Dosgi.dataAreaRequiresExplicitInit=true ^
-Dlogback.configurationFile=configuration/logback.xml ^
-Dpde.jreProfile=JavaSE-17

@echo off
