@echo off
REM
REM Team for Capella Projects Importer
REM
REM Documentation is available :
REM * in T4C documentation in "Importer Configuration" chapter
REM * typing importer -help (see result in log)
REM
REM Each option can also be added directly on the commandline: e.g. "importer.bat -repositoryCredentials repositoryCredentials.properties -projectname only_mine"
REM
REM Communication with server using https
REM   - switch httpPort to server https port (default: 8443): -httpPort 8443
REM   - trusted certificate: 
REM      - simply switch the httpsConnection parameter to true: -httpsConnection true
REM   - self-signed certificate: 
REM      - switch the httpsConnection parameter to true: -httpsConnection true
REM      - complete  -vmargs with -Dfr.obeo.dsl.viewpoint.collab.https.jetty.ssl.context.trustall=true
REM      - or install your certificate in the JVM
REM
REM Http credentials can be passed through several ways:
REM   - (default) registered in the secure storage, see Scheduler jobs and/or toolsCredentials.bat
REM   - as program arguments -httpLogin admin and -httpPassword token_value
REM   - in a properties file referenced from program arguments with -httpCredentials httpCredentials.properties
@echo on

cd ../capella

REM Communication with server using http
capellac.exe ^
--launcher.suppressErrors ^
-nosplash -console -consoleLog ^
-data importer-workspace ^
-application com.thalesgroup.mde.melody.collab.importer ^
-repositoryCredentials ../tools/repositoryCredentials.properties ^
-checksize -1 -closeserveronfailure false -stopRepositoryOnFailure false ^
-httpHost localhost ^
-httpPort 8080 ^
-httpsConnection false ^
%* ^
-vmargs -Xms1000m -Xmx3000m -Xss4m ^
-XX:+UseG1GC -XX:+UseStringDeduplication ^
-Dorg.eclipse.net4j.util.om.trace.disable=true ^
-Dosgi.requiredJavaVersion=17 ^
-Dosgi.dataAreaRequiresExplicitInit=true ^
-Dlogback.configurationFile=configuration/logback.xml ^
-Dfr.obeo.dsl.viewpoint.collab.import.gmf.notation.keep.cdoid.as.xmiid=true ^
-Dfr.obeo.dsl.viewpoint.collab.import.other.elements.keep.cdoid.as.xmiid=true ^
-Dpde.jreProfile=JavaSE-17

@echo off
