echo Installing Team for Capella Administration Features

@echo off
set CALLER_PATH=%CD%
set SCRIPT_PATH=%~dp0

set UPDATE_SITE_PATH=%SCRIPT_PATH%../updateSite/com.thalesgroup.mde.melody.team.license.update-7.0.1-202601261505.zip

if exist "%UPDATE_SITE_PATH%" (
  echo Update site found
) else (
   cd "%CALLER_PATH%"
   echo Update site %UPDATE_SITE_PATH% not found.
   exit /b 1
)

cd "%SCRIPT_PATH%../capella"

set WORKSPACE_NAME=installationWorkspace
set WORKSPACE_EXISTS_BEFORE=0
if exist %WORKSPACE_NAME% (
  set WORKSPACE_EXISTS_BEFORE=1
)

set INSTALL_TAG="InstallAdminFeatures"
set FEATURE_LIST="com.thalesgroup.mde.melody.collab.admin.client.feature.feature.group,com.thalesgroup.mde.melody.collab.user.profile.feature.feature.group"

@echo on
capellac.exe ^
-nosplash -console -consoleLog ^
-data %WORKSPACE_NAME% ^
-application org.eclipse.equinox.p2.director ^
-profile DefaultProfile ^
-tag %INSTALL_TAG% ^
-installIU %FEATURE_LIST% ^
-repository "jar:file:///%UPDATE_SITE_PATH%!"

@echo off
if %WORKSPACE_EXISTS_BEFORE% == 0 (
  if exist %WORKSPACE_NAME% (
    RD /S /Q %WORKSPACE_NAME%
  )
)

cd "%CALLER_PATH%"