echo Installing Team for Capella in Capella

@echo off
set CALLER_PATH=%CD%
set SCRIPT_PATH=%~dp0

set UPDATE_SITE_PATH=%SCRIPT_PATH%../updateSite/com.thalesgroup.mde.melody.team.license.update-7.0.1-202601261505.zip

if exist "%UPDATE_SITE_PATH%" (
  echo Update site found
) else (
   cd "%CALLER_PATH%"
   echo Update site %UPDATE_SITE_PATH% not found.
   exit /b 1
)

set HOTFIX_UPDATE_SITE_PATH=%SCRIPT_PATH%../updateSite/com.thalesgroup.mde.melody.team.license.update.patch-7.0.1.202508281230.zip

if exist "%HOTFIX_UPDATE_SITE_PATH%" (
  echo HotFixes Update site found
) else (
   cd "%CALLER_PATH%"
   echo Update site %HOTFIX_UPDATE_SITE_PATH% not found.
   exit /b 1
)

cd "%SCRIPT_PATH%../capella"

set WORKSPACE_NAME=installationWorkspace
set WORKSPACE_EXISTS_BEFORE=0
if exist %WORKSPACE_NAME% (
  set WORKSPACE_EXISTS_BEFORE=1
)

set INSTALL_TAG="InstallTeamForCapella"
set FEATURE_LIST="com.thalesgroup.mde.melody.collab.feature.feature.group,com.thalesgroup.mde.melody.collab.licbranding.feature.feature.group,org.polarsys.capella.common.ui.feature.patch.feature.group,org.polarsys.capella.core.libraries.feature.patch.feature.group,org.polarsys.capella.core.re.feature.patch.feature.group"

@echo on
capellac.exe ^
-nosplash -console -consoleLog ^
-data %WORKSPACE_NAME% ^
-application org.eclipse.equinox.p2.director ^
-profile DefaultProfile ^
-tag %INSTALL_TAG% ^
-installIU %FEATURE_LIST% ^
-repository "jar:file:///%UPDATE_SITE_PATH%!,jar:file:///%HOTFIX_UPDATE_SITE_PATH%!"

@echo off
REM -repository jar:file:///c:/path/to/team/for/capella/update/site/com.thalesgroup.mde.melody.team.update-7.0.1-202001312000.zip!/
REM -destination file:///c:/path/to/team/for/capella/client if this script is launched from an other product than the capella install to update

@echo off
if %WORKSPACE_EXISTS_BEFORE% == 0 (
  if exist %WORKSPACE_NAME% (
    RD /S /Q %WORKSPACE_NAME%
  )
)

echo Updating configuration files
setlocal enabledelayedexpansion
set CONFIGFOLDER=configuration
set INTEXTFILE=config.ini.bak
set OUTTEXTFILE=config.ini
set SEARCHTEXT=plugins/org.polarsys.capella.core.platform.sirius.ui.perspective
set REPLACETEXT=plugins/com.thalesgroup.mde.melody.collab.ui
set OUTPUTLINE=
set ECLIPSE_INI_FILE=capella.ini
set ECLIPSE_INI_BACKUP_FILE=capella.ini.bak
set PLUGIN_CUSTOMIZATION_INI_FILE=pluginCustomization.ini
set LICENSE_FILE=license.html
set LOGBACK_CONFIG_FILE=logback.xml

if not exist %ECLIPSE_INI_BACKUP_FILE% (
  echo Creating backup file: %ECLIPSE_INI_BACKUP_FILE%
  ren %ECLIPSE_INI_FILE% %ECLIPSE_INI_BACKUP_FILE%
  echo #This configuration file was updated by: installation script of Team for Capella >> %ECLIPSE_INI_FILE%
  echo #add -pluginCustomization %PLUGIN_CUSTOMIZATION_INI_FILE% >> %ECLIPSE_INI_FILE%
  echo #add -Dorg.eclipse.net4j.util.om.trace.disable=true as vmargs >> %ECLIPSE_INI_FILE%
  echo #%date% %time% >> %ECLIPSE_INI_FILE%
  echo -pluginCustomization >> %ECLIPSE_INI_FILE%
  echo %PLUGIN_CUSTOMIZATION_INI_FILE% >> %ECLIPSE_INI_FILE%
  echo -pluginCustomization %PLUGIN_CUSTOMIZATION_INI_FILE% has been added at the beginning of %ECLIPSE_INI_FILE%
  type %ECLIPSE_INI_BACKUP_FILE% >> %ECLIPSE_INI_FILE%
  echo -Dorg.eclipse.net4j.util.om.trace.disable=true >> %ECLIPSE_INI_FILE%
  echo -Dorg.eclipse.net4j.util.om.trace.disable=true vmArgs has been added at the end of %ECLIPSE_INI_FILE%
  echo -Dlogback.configurationFile=configuration/logback.xml >> %ECLIPSE_INI_FILE%
  echo -Dlogback.configurationFile=configuration/logback.xml vmArgs has been added at the end of %ECLIPSE_INI_FILE%
  echo -Dfr.obeo.dsl.viewpoint.collab.import.gmf.notation.keep.cdoid.as.xmiid=true >> %ECLIPSE_INI_FILE%
  echo -Dfr.obeo.dsl.viewpoint.collab.import.gmf.notation.keep.cdoid.as.xmiid=true vmArgs has been added at the end of %ECLIPSE_INI_FILE%
  echo -Dfr.obeo.dsl.viewpoint.collab.import.other.elements.keep.cdoid.as.xmiid=true >> %ECLIPSE_INI_FILE%
  echo -Dfr.obeo.dsl.viewpoint.collab.import.other.elements.keep.cdoid.as.xmiid=true vmArgs has been added at the end of %ECLIPSE_INI_FILE%
  echo -Dfr.obeo.dsl.viewpoint.collab.ui.registered.repositories.use.shared.configuration.location=false >> %ECLIPSE_INI_FILE%
  echo -Dfr.obeo.dsl.viewpoint.collab.ui.registered.repositories.use.shared.configuration.location=false vmArgs has been added at the end of %ECLIPSE_INI_FILE%
) else (
 echo Info:
 echo   Backup file %ECLIPSE_INI_BACKUP_FILE% already exist.
 echo   Hence %ECLIPSE_INI_FILE% has not been modified this time.
)

if not exist %PLUGIN_CUSTOMIZATION_INI_FILE% (
 echo Copying tools/resources/client_rootfiles/%PLUGIN_CUSTOMIZATION_INI_FILE% in capella/
 copy "..\tools\resources\client_rootfiles\%PLUGIN_CUSTOMIZATION_INI_FILE%" "%PLUGIN_CUSTOMIZATION_INI_FILE%" 
) else (
 echo Info:
 echo   File %PLUGIN_CUSTOMIZATION_INI_FILE% already exist.
 echo   Hence %PLUGIN_CUSTOMIZATION_INI_FILE% has not been replaced nor modified this time.
 echo   Compare capella/%PLUGIN_CUSTOMIZATION_INI_FILE% with /tools/client_rootfiles/%PLUGIN_CUSTOMIZATION_INI_FILE% for a manual customization.
)

if not exist %LICENSE_FILE% (
 echo Copying tools/%LICENSE_FILE% in capella/
 copy "..\tools\%LICENSE_FILE%" "%LICENSE_FILE%" 
) else (
 echo Info:
 echo   File %LICENSE_FILE% already exist.
 echo   Hence %LICENSE_FILE% has not been replaced nor modified this time.
 echo   Compare capella/%LICENSE_FILE% with /tools/%LICENSE_FILE% for a manual check.
)

if not exist configuration\%LOGBACK_CONFIG_FILE% (
 echo Copying tools/resources/client_rootfiles/%LOGBACK_CONFIG_FILE% in capella/configuration/
 copy "..\tools\resources\client_rootfiles\%LOGBACK_CONFIG_FILE%" "configuration\%LOGBACK_CONFIG_FILE%" 
) else (
 echo Info:
 echo   File %LOGBACK_CONFIG_FILE% already exist.
 echo   Hence %LOGBACK_CONFIG_FILE% has not been replaced nor modified this time.
 echo   Compare capella/configuration/%LOGBACK_CONFIG_FILE% with /tools/client_rootfiles/%LOGBACK_CONFIG_FILE% for a manual customization.
)

cd "%CONFIGFOLDER%"
if not exist %INTEXTFILE% (
  echo Creating backup file: %CONFIGFOLDER%\%INTEXTFILE%
  ren %OUTTEXTFILE% %INTEXTFILE%
  echo #This configuration file was updated by: installation script of Team for Capella >> %OUTTEXTFILE%
  echo #old osgi.splashPath platform\:/base/plugins/org.polarsys.capella.core.platform.sirius.ui.perspective >> %OUTTEXTFILE%
  echo #new osgi.splashPath platform\:/base/plugins/com.thalesgroup.mde.melody.collab.ui >> %OUTTEXTFILE%
  echo #%date% %time% >> %OUTTEXTFILE%

  for /f "delims=" %%A in ( '"type %INTEXTFILE%"') do (
    SET string=%%A
    SET modified=!string:%SEARCHTEXT%=%REPLACETEXT%!
    echo !modified!>> %OUTTEXTFILE%
  )

  echo osgi.splashPath property has been replaced in %CONFIGFOLDER%\%OUTTEXTFILE%
) else (
 echo Info:
 echo   Backup file %CONFIGFOLDER%\%INTEXTFILE% already exist.
 echo   Hence %CONFIGFOLDER%\%OUTTEXTFILE% has not been modified this time.
)

cd "%CALLER_PATH%"