@echo off
REM
REM Team for Capella Repository Maintenance
REM
REM Communication with server using https
REM   - switch httpPort to server https port (default: 8443): -httpPort 8443
REM   - trusted certificate: 
REM      - simply switch the httpsConnection parameter to true: -httpsConnection true
REM   - self-signed certificate: 
REM      - switch the httpsConnection parameter to true: -httpsConnection true
REM      - complete  -vmargs with -Dfr.obeo.dsl.viewpoint.collab.https.jetty.ssl.context.trustall=true
REM      - or install your certificate in the JVM
REM
REM Http credentials can be passed through several ways:
REM   - (default) registered in the secure storage, see Scheduler jobs and/or toolsCredentials.bat
REM   - as program arguments -httpLogin admin and -httpPassword token_value
REM   - in a properties file referenced from program arguments with -httpCredentials httpCredentials.properties
@echo on

cd ../capella

REM Communication with server using http
capellac.exe ^
--launcher.suppressErrors ^
-nosplash -console -consoleLog ^
-data maintenance-workspace ^
-application com.thalesgroup.mde.melody.collab.maintenance ^
-repositoryCredentials ../tools/repositoryCredentials.properties ^
-httpHost localhost ^
-httpPort 8080 ^
-httpsConnection false ^
%* ^
-vmargs -Xms1000m -Xmx3000m -Xss4m ^
-XX:+UseG1GC -XX:+UseStringDeduplication ^
-Dorg.eclipse.net4j.util.om.trace.disable=true ^
-Dosgi.requiredJavaVersion=17 ^
-Dosgi.dataAreaRequiresExplicitInit=true ^
-Dlogback.configurationFile=configuration/logback.xml ^
-Dpde.jreProfile=JavaSE-17

@echo off
